/*********************************************************************
//  created:    2011/04/26
//  filename:   DbtRawCanReader.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: DbtRawCanReader.cpp 1182 2012-07-05 16:42:32Z kurdejma $
//
//  purpose:    
*********************************************************************/


#include "kernel/ComponentFactory.h"
#include "kernel/DbiteFileTypes.h"
#include "kernel/Log.h"

#include "kernel/road_time.h"

using namespace pacpus;
using namespace std;

#include "DbtRawCanReader.h"

DECLARE_STATIC_LOGGER("pacpus.base.DbtRawCanReader");

/// Component factory for DbtRawCanReader
static ComponentFactory<DbtRawCanReader> sFactory("DbtRawCanReader");

/// Constructor
DbtRawCanReader::DbtRawCanReader(QString name)
    : ComponentBase(name)
{
}

/// Destructor
DbtRawCanReader::~DbtRawCanReader()
{
}

/// Configures the component
ComponentBase::COMPONENT_CONFIGURATION DbtRawCanReader::configureComponent(XmlComponentConfig config)
{
    dbtFileName_ = config.getProperty("dbt");

    return ComponentBase::CONFIGURED_OK;
}

/// Starts the component
void DbtRawCanReader::startActivity()
{
  start();
}

/// Stops the component 
void DbtRawCanReader::stopActivity()
{
    
}

void DbtRawCanReader::run()
{
  road_time_t time;
  road_timerange_t tr;
  CanFrame dbtData;
  TimestampedCanFrame dataToDecode;

  // create the DBT file
  dbtFile_.open(dbtFileName_.toStdString(), ReadMode);

  LOG_INFO("DBT file opened for reading");

  for (;;) 
  {
    if ( !dbtFile_.readRecord(time, tr, reinterpret_cast<char *>(&dbtData) ) )
      break;
    dataToDecode.frame = dbtData;
    dataToDecode.time = time; 
    dataToDecode.timerange = tr;

    dispatchCanFrame(dataToDecode);
  }

  LOG_INFO("reading finished");

  dbtFile_.close(); 

}
