
#ifndef __CANSUBSCRIPTION_H__
#define __CANSUBSCRIPTION_H__

#include <QMultiHash>

#include "CanGatewayConfig.h"
#include "CanDecoderBase.h"

#include "structure/structureCanCarmen.h"


template <class T> class QList; 
//template <class T, class R> class QMultiHash; 

namespace pacpus {

class CANGATEWAY_API CanSubscription
{
public:
  CanSubscription() { subscribers_.clear();}
  virtual ~CanSubscription() {} 

  // return true if the subscription of the component to the specified can ID list succeeds, false else
  // warning: it is possible that some <Component*,id> pairs have been registered and other not. 
  bool subscribe(const CanDecoderBase* who, const QList<int>& canId);

  // TODO
  bool unsubscribe(const CanDecoderBase* who, const QList<int>& canId);

  // TODO
  //QList<int> getSubscription(const ComponentBase* who) {};

  bool dispatchCanFrame(const TimestampedCanFrame & message);

private:
  // list of subscribers, we provide them can data
  // structure of the hash: key is the can ID and value is the pointer to the subscribed component
  QMultiHash<int, CanDecoderBase *> subscribers_;

};

}

#endif 
