/*********************************************************************
//  created:    2011/04/26
//  filename:   DbtRawCanReader.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    
*********************************************************************/

#ifndef __DbtRawCanReader_H__
#define __DbtRawCanReader_H__

#include <QThread>

#include "kernel/ComponentBase.h"
#include "kernel/DbiteFile.h"

using namespace pacpus;

#include "CanSubscription.h"

// Export macro for DummyPacpusComponent DLL for Windows only
#ifdef WIN32
#   ifdef DBTRAWCANREADER_EXPORTS
        // make DLL
#       define DBTRAWCANREADER_API __declspec(dllexport)
#   else
        // use DLL
#       define DBTRAWCANREADER_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this 
#   define DBTRAWCANREADER_API
#endif


namespace pacpus {

class DBTRAWCANREADER_API DbtRawCanReader
        : public QThread
        , public ComponentBase
        , public CanSubscription
{
    Q_OBJECT

public:
    DbtRawCanReader(QString name);
    ~DbtRawCanReader();

protected:
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    virtual void startActivity();
    virtual void stopActivity();

    void run();

private:
  QString dbtFileName_;
  pacpus::DbiteFile dbtFile_;
  
};

}

#endif // DbtRawCanReader_H
