// Includes, pacpus.
#include <PacpusTools/PeriodicWorker.h>

// Includes, qt.
#include <QTimer>

using namespace pacpus;

PeriodicWorker::PeriodicWorker()
  : AsyncWorkerBase()
  , mHeartbeat(NULL)
{
  mHeartbeat = new QTimer(this);
}

PeriodicWorker::~PeriodicWorker()
{
}

void
PeriodicWorker::startWork(int msec)
{
  mHeartbeat->start(msec);
  connect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
  
  this->start();
}

void
PeriodicWorker::stopWork()
{
  disconnect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
}
