// *********************************************************************
//
//  created:    2015/09/18
//  filename:   MessageComponent.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component header file
//
// *********************************************************************


#ifndef __MessageComponent_h__
#define __MessageComponent_h__

#include <Pacpus/kernel/PacpusLibConfig.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <QTimer>

namespace pacpus 
{

  class PACPUSLIB_API MessageComponent
  : public QObject
  , public ComponentBase
  {
    Q_OBJECT

  public:
    // Specific constructor for pacpus component
    MessageComponent(QString name); 
    ~MessageComponent();

    // 3 inherited virtual pure methods
    virtual void startActivity();
    virtual void stopActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

    virtual void addInputs();
    virtual void addOutputs();

    // void produceOutput();
    // void processInput(const int& value);


  private:
    // Add here your private variables
    QTimer timer_;
    float period_;
    int counter_; 

  private slots: 
    void display();

    // Declaration of an output
    // OutputInterface<int, MessageComponent>* out1_;
    

  }; // end class MessageComponent

} // end namespace pacpus

#endif 