/*********************************************************************
//  created:    2007/07/28 - 11:51
//  filename:   DbtPlyGgaManager.h
//
//  author:     Gerald Dherbomez 
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Dbite Player GGA Manager
*********************************************************************/

#ifndef DBTPLYGGAMANAGER_H
#define DBTPLYGGAMANAGER_H

#include <qlcdnumber.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <iostream>

#include "Pacpus/DbitePlayer/DbtPlyFileManager.h"
//#include <Pacpus/structure/structure_gps.h>
#include "../Gps/structure_gps.h"
#include "Pacpus/kernel/ComponentManager.h"//moved from .cpp

#include <Pacpus/kernel/InputOutputInterface.h>
//#include "DbitePlayer/SensorTcpServer.h" //added
//#include "Pacpus/PacpusTools/ShMem.h"

#include "DbtPlyGpsConfig.h"

namespace pacpus {

class DBTPLYGPS_API DbtPlyGgaManager
        : public DbtPlyFileManager
{
    Q_OBJECT
    
public:
    DbtPlyGgaManager(QString name);
    ~DbtPlyGgaManager();

    virtual void startActivity();
    virtual void stopActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    virtual void addInputs();
    virtual void addOutputs();

protected:
    void processData(road_time_t t, road_timerange_t tr , void *buf);
    void displayUI();

private:
    // Local copy of GGA data with timestamp
    TimestampedGgaFrame mGga;

    // Declaration of outputs
    OutputInterface<TimestampedGgaFrame, DbtPlyGgaManager>* outGga;

    // Variables for GUI : TODO
    /*QWidget *w;
    QLabel* lat;
    QLCDNumber *latVal;
    QLabel* lon;
    QLCDNumber *lonVal;
    QGroupBox *prop;*/

};

} // namespace pacpus

#endif // DBTPLYGGAMANAGER_H
