/*********************************************************************
//  created:    20011/07/06 - 16:51
//  filename:   DbtPlyCPTComponent.h
//
//  author:     Sergio Rodriguez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
//
//  version:    $Id: $
//
//  purpose:
*********************************************************************/

#ifndef DBTPLYCPTCOMPONENT_H
#define DBTPLYCPTCOMPONENT_H

#include "DbitePlayer/DbtPlyFileManager.h"
#include "../NMEA0183/include/nmea0183.h"

//#include <boost/scoped_ptr.hpp>
//#include <QScopedPointer>

// Export macro for CPT DLL for Windows only
#ifdef WIN32
#   ifdef CPT_EXPORTS
        // make DLL
#       define CPT_API __declspec(dllexport)
#   else
        // use DLL
#       define CPT_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this
#   define CPT_API
#endif

#define UNKNOWN_NMEA_FRAME -1

struct CPT_API Stream8Position
{
    int32_t dataPos;
    int32_t length;
};


#include "structure/structure_gps.h"
#include "structure/genericStructures.h"

//#include "../PoseViewer/PoseViewer.h"

namespace pacpus {

//class PoseViewer;
class ShMem;

//struct Pose;

class CPT_API DbtPlyCPTComponent
        : public DbtPlyFileManager
{
    Q_OBJECT

public:
    DbtPlyCPTComponent(QString name);
    ~DbtPlyCPTComponent();

protected:
    void processData(road_time_t t, road_timerange_t tr , void * buf);
    void displayUI();

    ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    void startActivity();
    void stopActivity();

    virtual void addInputs();
    virtual void addOutputs();

//Q_SIGNALS:
    //void newPoseAvailable(Pose pose);

private:
    //boost::scoped_ptr<PoseViewer> mPoseViewer;
   //QScopedPointer<PoseViewer> mPoseViewer;

    //ShMems
    ShMem * mShMem;
    //ShMem data variables
    char * allFramesBuffer;

    QString mDataFilename;

    //NMEA to do
    NMEA0183 nmea0183_;

    trame_gga_dbl ggaFrame_;
    trame_gsa gsaFrame_;
    trame_gst gstFrame_;
    trame_gsv gsvFrame_;
    trame_hdt hdtFrame_;
    trame_rmc rmcFrame_;
    trame_rot rotFrame_;
    trame_vtg vtgFrame_;
    trame_zda zdaFrame_;

    //SPAN done
    TimestampedBestgpsposaFrame bestgpsposaFrame_;
    TimestampedInspvaaFrame     inspvaFrame_;
    TimestampedInscovFrame      inscovFrame_;
    TimestampedRawimusaFrame    rawimuFrame_;

    Pose3D genericEnuPose_;
};

} // namespace pacpus

#endif // DBTPLYCPTCOMPONENT_H
