// *********************************************************************
//
//  created:    2015/09/18
//  filename:   FizzBuzz.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component source file 
//
// *********************************************************************

#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/kernel/DbiteFileTypes.h"

#include "FizzBuzz.h"

using namespace pacpus;


////////////////////////////////////////////////////////////////////////////////
/// Construct the factory
static ComponentFactory<FizzBuzz> sFactory("FizzBuzz");




/************************************************************************/
/* Constructor
/************************************************************************/
FizzBuzz::FizzBuzz(QString name)
  : ComponentBase(name)
{

}


/************************************************************************/
/* Destructor
/************************************************************************/
FizzBuzz::~FizzBuzz()
{  

}


/************************************************************************/
/* Start function, called by the ComponentManager when a start() 
/* command is received
/************************************************************************/
void FizzBuzz::startActivity()
{
  // if you add an ouput, uncomment the line
  // out1_ = getTypedOutput<int, FizzBuzz>("value");

  LOG_INFO("FizzBuzz started!");

  // Algo
  for (counter_ = 1 ; counter_ <= 100 ; counter_++)
  {
    if ( counter_ % 3  && counter_ % 5  )
      std::cout << counter_;
    else 
    {
      if (!(counter_ % 3))
        std::cout << "Fizz";
      if (!(counter_ % 5))
        std::cout << "Buzz";
    }
    std::cout << std::endl;
  }

}


/************************************************************************/
/* Stop function, called by the ComponentManager when a stop() 
/* command is received
/************************************************************************/
void FizzBuzz::stopActivity()
{
  LOG_INFO("FizzBuzz stopped!");
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void FizzBuzz::addInputs()
{
  // uncomment to add an input
  // addInput<int, FizzBuzz>("value", &FizzBuzz::processInput);
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void FizzBuzz::addOutputs()
{
  // empty: no output
  // addOutput<int, ProducerExample>("value");
}



/************************************************************************/
/* Example function that produces an output
/************************************************************************/
// void FizzBuzz::produceOutput()
// {
//   int val = 12;
//   checkedSend(out1_, val);
// }


/************************************************************************/
/* Example function that processes an input
/************************************************************************/
// void processInput(const int& value)
// {
//    
// }


/************************************************************************/
/* Configuration of the component, called by the ComponentManager after 
/* the construction of the object
/************************************************************************/
ComponentBase::COMPONENT_CONFIGURATION FizzBuzz::configureComponent(XmlComponentConfig config)
{

	return ComponentBase::CONFIGURED_OK;
}

