// *********************************************************************
//
//  created:    2015/10/26
//  filename:   AdditionComponent.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component header file
//
// *********************************************************************


#ifndef __AdditionComponent_h__
#define __AdditionComponent_h__

#include <Pacpus/kernel/PacpusLibConfig.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <QTimer>

namespace pacpus 
{

  class PACPUSLIB_API AdditionComponent
  : public QObject
  , public ComponentBase
  {
    Q_OBJECT

  public:
    // Specific constructor for pacpus component
    AdditionComponent(QString name); 
    ~AdditionComponent();

    // 3 inherited virtual pure methods
    virtual void startActivity();
    virtual void stopActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

    virtual void addInputs();
    virtual void addOutputs();

  private slots:
    void produceOutput();

  private:
    // Add here your private variables
    double valueToAdd_; 
    double valueToSend_; 
    bool initiator_;
    QTimer timer_;
    void processInput(const double& value);

    // Declaration of an output
    OutputInterface<double, AdditionComponent>* out1_;
    

  }; // end class AdditionComponent

} // end namespace pacpus

#endif 
