// *********************************************************************
//
//  created:    2015/10/26
//  filename:   VectorAdditionComponent.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component source file 
//
// *********************************************************************

#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/kernel/DbiteFileTypes.h"

#include "VectorAdditionComponent.h"

#include <QMutableVectorIterator>
#include <QVectorIterator>

using namespace pacpus;


////////////////////////////////////////////////////////////////////////////////
/// Construct the factory
static ComponentFactory<VectorAdditionComponent> sFactory("VectorAdditionComponent");




/************************************************************************/
/* Constructor
/************************************************************************/
VectorAdditionComponent::VectorAdditionComponent(QString name)
  : ComponentBase(name)
{
  valueToAdd_ = 0.0;
  initiator_ = false;
  vectorSize_ = 0;
}


/************************************************************************/
/* Destructor
/************************************************************************/
VectorAdditionComponent::~VectorAdditionComponent()
{  

}


/************************************************************************/
/* Start function, called by the ComponentManager when a start() 
/* command is received
/************************************************************************/
void VectorAdditionComponent::startActivity()
{
  // if you add an ouput, uncomment the line
  out1_ = getTypedOutput< QVector<double> , VectorAdditionComponent>("valueOut");
  valueToSend_.fill(0.0, vectorSize_);

  if (initiator_)
    timer_.singleShot(1000, this, SLOT(produceOutput()));
}


/************************************************************************/
/* Stop function, called by the ComponentManager when a stop() 
/* command is received
/************************************************************************/
void VectorAdditionComponent::stopActivity()
{

}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void VectorAdditionComponent::addInputs()
{
  // uncomment to add an input
  addInput<QVector<double>, VectorAdditionComponent>("valueIn", &VectorAdditionComponent::processInput);
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void VectorAdditionComponent::addOutputs()
{
  // empty: no output
  addOutput<QVector<double>, VectorAdditionComponent>("valueOut");
}


/************************************************************************/
/* Example function that produces an output
/************************************************************************/
void VectorAdditionComponent::produceOutput()
{
  checkedSend(out1_, valueToSend_);
  LOG_INFO(getName() << ": values sent: first: " << valueToSend_.first() << " last: " << valueToSend_.last() );
}


/************************************************************************/
/* Example function that processes an input
/************************************************************************/
void VectorAdditionComponent::processInput(const QVector<double>& value)
{
  LOG_INFO(getName() << ": value received: " << value.first() << " last: " << value.last());

  QMutableVectorIterator<double> i(valueToSend_);
  QVectorIterator<double> j(value); 
  int k = 0; 
  while (i.hasNext())
  {
    i.next();
    i.setValue( j.next() + valueToAdd_ + k);
    k++;
  }

  // !!!!!!!!!!! WARNING !!!!!!!!!!!
  // We avoid to use a "sleep()" which is blocking. 
  timer_.singleShot(1000, this, SLOT(produceOutput()));
}


/************************************************************************/
/* Configuration of the component, called by the ComponentManager after 
/* the construction of the object
/************************************************************************/
ComponentBase::COMPONENT_CONFIGURATION VectorAdditionComponent::configureComponent(XmlComponentConfig config)
{
  valueToAdd_ = config.getDoubleProperty("valueToAdd"); 
  initiator_ = config.getBoolProperty("initiateCommunication");
  vectorSize_ = config.getIntProperty("vectorSize");

	return ComponentBase::CONFIGURED_OK;
}

