// *********************************************************************
//
//  created:    2015/10/26
//  filename:   VectorAdditionComponent.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component header file
//
// *********************************************************************


#ifndef __VectorAdditionComponent_h__
#define __VectorAdditionComponent_h__

#include <Pacpus/kernel/PacpusLibConfig.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <QTimer>
#include <QVector>

namespace pacpus 
{

  class PACPUSLIB_API VectorAdditionComponent
  : public QObject
  , public ComponentBase
  {
    Q_OBJECT

  public:
    // Specific constructor for pacpus component
    VectorAdditionComponent(QString name); 
    ~VectorAdditionComponent();

    // 3 inherited virtual pure methods
    virtual void startActivity();
    virtual void stopActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

    virtual void addInputs();
    virtual void addOutputs();

  private slots:
    void produceOutput();

  private:
    // Add here your private variables
    double valueToAdd_; 
    QVector<double> valueToSend_; 
    int vectorSize_;
    bool initiator_;
    QTimer timer_;
    void processInput(const QVector<double>& value);

    // Declaration of an output
    OutputInterface<QVector<double>, VectorAdditionComponent>* out1_;
    

  }; // end class VectorAdditionComponent

} // end namespace pacpus

#endif 