// *********************************************************************
//
//  created:    2015/10/26
//  filename:   AdditionComponent.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component source file 
//
// *********************************************************************

#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/kernel/DbiteFileTypes.h"

#include "AdditionComponent.h"

using namespace pacpus;


////////////////////////////////////////////////////////////////////////////////
/// Construct the factory
static ComponentFactory<AdditionComponent> sFactory("AdditionComponent");




/************************************************************************/
/* Constructor
/************************************************************************/
AdditionComponent::AdditionComponent(QString name)
  : ComponentBase(name)
{
  valueToAdd_ = 0.0;
  valueToSend_ = 0.0;
  initiator_ = false;
}


/************************************************************************/
/* Destructor
/************************************************************************/
AdditionComponent::~AdditionComponent()
{  

}


/************************************************************************/
/* Start function, called by the ComponentManager when a start() 
/* command is received
/************************************************************************/
void AdditionComponent::startActivity()
{
  // if you add an ouput, uncomment the line
  out1_ = getTypedOutput<double, AdditionComponent>("valueOut");
  if (initiator_)
    timer_.singleShot(1000, this, SLOT(produceOutput()));
}


/************************************************************************/
/* Stop function, called by the ComponentManager when a stop() 
/* command is received
/************************************************************************/
void AdditionComponent::stopActivity()
{

}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void AdditionComponent::addInputs()
{
  // uncomment to add an input
  addInput<double, AdditionComponent>("valueIn", &AdditionComponent::processInput);
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void AdditionComponent::addOutputs()
{
  // empty: no output
  addOutput<double, AdditionComponent>("valueOut");
}


/************************************************************************/
/* Example function that produces an output
/************************************************************************/
void AdditionComponent::produceOutput()
{
  checkedSend(out1_, valueToSend_);
  LOG_INFO(getName() << ": value sent: " << valueToSend_);
}


/************************************************************************/
/* Example function that processes an input
/************************************************************************/
void AdditionComponent::processInput(const double& value)
{
  LOG_INFO(getName() << ": value received: " << value);
  valueToSend_ = value + valueToAdd_;

  // !!!!!!!!!!! WARNING !!!!!!!!!!!
  // We avoid to use a "sleep()" which is blocking. 
  timer_.singleShot(1000, this, SLOT(produceOutput()));
}


/************************************************************************/
/* Configuration of the component, called by the ComponentManager after 
/* the construction of the object
/************************************************************************/
ComponentBase::COMPONENT_CONFIGURATION AdditionComponent::configureComponent(XmlComponentConfig config)
{
  valueToAdd_ = config.getDoubleProperty("valueToAdd"); 
  initiator_ = config.getBoolProperty("initiateCommunication");

	return ComponentBase::CONFIGURED_OK;
}

