/*********************************************************************
//  created:    20011/07/06 - 16:51
//  filename:   DbtPlyCPTComponent.h
//
//  author:     Sergio Rodriguez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
//
//  version:    $Id: $
//
//  purpose:
*********************************************************************/

#ifndef DBTPLYCPTCOMPONENT_H
#define DBTPLYCPTCOMPONENT_H

#include "DbitePlayer/DbtPlyFileManager.h"
#include "../NMEA0183/include/nmea0183.h"
#include "StdDbtPlayerComponentsConfig.h"

#define UNKNOWN_NMEA_FRAME -1

struct STDDBTPLAYERCOMPONENTS_API Stream8Position
{
    int32_t dataPos;
    int32_t length;
};


#include <Pacpus/structures/structure_gps.h>
#include <Pacpus/structures/genericStructures.h>
#include <Pacpus/kernel/road_time.h>
#include <QVector3D>
#include <QMatrix4x4>

namespace pacpus {
class ShMem;

class STDDBTPLAYERCOMPONENTS_API DbtPlyCPTComponent
        : public DbtPlyFileManager
{
    Q_OBJECT

public:
    DbtPlyCPTComponent(QString name);
    ~DbtPlyCPTComponent();

protected:
    void processData(road_time_t t, road_timerange_t tr , void * buf);
    void displayUI();

    ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    void startActivity();
    void stopActivity();

    virtual void addInputs();
    virtual void addOutputs();

private:
    //ShMems
    ShMem * mShMem;
    //ShMem data variables
    char * allFramesBuffer;

    QString mDataFilename;

    // NMEA0183
    trame_gga_dbl ggaFrame_;
    trame_gsa gsaFrame_;
    trame_gst gstFrame_;
    trame_gsv gsvFrame_;
    trame_hdt hdtFrame_;
    trame_rmc rmcFrame_;
    trame_rot rotFrame_;
    trame_vtg vtgFrame_;
    trame_zda zdaFrame_;

    //SPAN done
    TimestampedBestgpsposaFrame bestgpsposaFrame_;
    TimestampedInspvaaFrame     inspvaFrame_;
    TimestampedInscovFrame      inscovFrame_;
    TimestampedRawimusaFrame    rawimuFrame_;

    Pose3D genericEnuPose_;
};

} // namespace pacpus

#endif // DBTPLYCPTCOMPONENT_H
