// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    Month, 2012
/// @version $Id: DbiteException.h 114 2013-06-25 08:55:43Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_DBITEEXCEPTION_H
#define DEF_PACPUS_DBITEEXCEPTION_H

#include <Pacpus/kernel/FileLibConfig.h>

#include <exception>
#include <string>

#ifdef _MSC_VER
#   pragma warning(push)
#   pragma warning(disable: 4251)
#endif // _MSC_VER

namespace pacpus {

/** DbiteException
 * @brief Exception thrown when an error manipulation a dbite file occured.
 */
class FILELIB_API DbiteException
    : public std::exception
{
public:
    /** Ctor of DbiteException.
     * @param what Information about the exception.
     */
    DbiteException(const std::string& what);

    /** Dtor of DbiteException. */
    virtual ~DbiteException() throw();


    /** Get more information about the error.
     * @return Message containing information about the error.
     */
    virtual const char* what() const throw();


private:
    std::string mWhat;
};

} // namespace pacpus

#ifdef _MSC_VER
#   pragma warning(pop)
#endif // _MSC_VER

#endif // DEF_PACPUS_DBITEEXCEPTION_H
