@echo off
setlocal ENABLEDELAYEDEXPANSION

set DebugOutput=1
set ExampleComponent=ExampleComponent

:argc
set argc=0
for %%x in (%*) do set /A argc+=1

:usage
if %argC% lss 1 (
    echo Usage:
    echo %0 ^<componentName^>
    goto:EOF
)

:args
set _componentName=%1
set _componentDir=%_componentName%Component
call :UCase _componentDir _componentDirCaps
if %DebugOutput%==1 (
    echo _componentName=%_componentName%
    echo _componentDir=%_componentDir%
    echo _componentDirCaps=%_componentDirCaps%
)

:cmake
::cmake %ExampleComponent% -DCOMPONENT_NAME:STRING=%_componentName%
::if %ERRORLEVEL% GEQ 1 (
::    echo CMake must be installed and added to PATH
::    goto:EOF
::)
::goto:EOF

:dir
if exist %_componentDir% (
    echo Directory %_componentDir% exists already!
    echo Please delete it first and retry.
    goto:EOF
)
mkdir %_componentDir%
if not exist %_componentDir% (
    echo Directory %_componentDir% could not be created!
    goto:EOF
)

:copy
::xcopy /S %ExampleComponent% %_componentDir%
copy %ExampleComponent%\CMakeLists.txt %_componentDir%\CMakeLists.txt
copy %ExampleComponent%\%ExampleComponent%.cpp %_componentDir%\%_componentDir%.cpp
copy %ExampleComponent%\%ExampleComponent%.h %_componentDir%\%_componentDir%.h
copy %ExampleComponent%\%ExampleComponent%Config.h %_componentDir%\%_componentDir%Config.h

:substitute
set SedFile=NewComponent.sed
set _currentDate=%DATE%
:: escape / character
set _currentDate=!_currentDate:/=\/!
:: take first 8 characters (without milliseconds)
set _currentTime=%TIME:~0,8%
set _userName=%USERNAME%

echo s/${^<PROJECT_NAME^>}/%_componentDir%/g > %SedFile%
echo s/${^<PROJECT_NAME_CAPS^>}/%_componentDirCaps%/g >> %SedFile%
echo s/${^<CURRENT_DATE^>}/%_currentDate%/g >> %SedFile%
echo s/${^<CURRENT_TIME^>}/%_currentTime%/g >> %SedFile%
echo s/${^<CURRENT_DATETIME^>}/%_currentDate% %_currentTime%/g >> %SedFile%
echo s/${^<USERNAME^>}/%_userName%/g >> %SedFile%

for /r . %%f in (%_componentDir%\*) do (
    if %DebugOutput%==1 (
        echo %%f
    )
    sed -f %SedFile% %%f > %%f.tmp
)

for /r . %%f in (%_componentDir%\*.tmp) do (
    if %DebugOutput%==1 (
        echo %%f
    )
    mv %%f %%~pnf
)

goto:EOF

:LCase
:UCase
:: Converts to upper/lower case variable contents
:: Syntax: CALL :UCase _VAR1 _VAR2
:: Syntax: CALL :LCase _VAR1 _VAR2
:: _VAR1 = Variable NAME whose VALUE is to be converted to upper/lower case
:: _VAR2 = NAME of variable to hold the converted value
:: Note: Use variable NAMES in the CALL, not values (pass "by reference")

SET _UCase=A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
SET _LCase=a b c d e f g h i j k l m n o p q r s t u v w x y z
SET _Lib_UCase_Tmp=!%1!
IF /I "%0"==":UCase" SET _Abet=%_UCase%
IF /I "%0"==":LCase" SET _Abet=%_LCase%
FOR %%Z IN (%_Abet%) DO (
    SET _Lib_UCase_Tmp=!_Lib_UCase_Tmp:%%Z=%%Z!
)
SET %2=%_Lib_UCase_Tmp%
GOTO:EOF
