/*********************************************************************
//  created:    2016/02/03 - 17:26
//  filename:   DbtPlyVtgManager.h
//
//  author:     Huu-Phuc NGUYEN, Gerald Dherbomez 
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Dbite Player Hdt Manager
*********************************************************************/

#ifndef DBTPLYHDTMANAGER_H
#define DBTPLYHDTMANAGER_H

#include <QLCDNumber>
#include <QGroupBox>
#include <QLabel>
#include <QLayout>

#include "Pacpus/DbitePlayer/DbtPlyFileManager.h"
#include "../Gps/structure_gps.h"
//#include "DbitePlayer/SensorTcpServer.h" //added
#include "Pacpus/PacpusTools/ShMem.h"

#include "DbtPlyGpsConfig.h"

namespace pacpus {

class ComponentManager;

class DBTPLYGPS_API DbtPlyHdtManager
        : public DbtPlyFileManager
{
public:
    DbtPlyHdtManager(QString name);
    ~DbtPlyHdtManager();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    
    virtual void addInputs();
    virtual void addOutputs();
protected:
    void processData(road_time_t t, road_timerange_t tr , void * buffer);
    virtual void startActivity();
    virtual void stopActivity();

private:
    trame_hdt * val; 
    // Local copy of Hdt data with timestamp
    TimestampedHdtFrame mHdt;

    // Declaration of outputs
    OutputInterface<TimestampedHdtFrame, DbtPlyHdtManager>* outHdt;

};

} // namespace pacpus

#endif // DBTPLYHDTMANAGER_H
