/*********************************************************************
// created:    2016/02/03 - 17:30

//
// author:     Huu-Phuc NGUYEN
//
// version:    $Id: DbtPlyHdtManager.cpp
//
// purpose:    Dbite Player HDT Manager implementation
*********************************************************************/

#include "DbtPlyHdtManager.h"

#include <cmath>
#include <qapplication.h>

#include "Pacpus/kernel/ComponentManager.h"

namespace pacpus {

//////////////////////////////////////////////////////////////////////////
// Construction de la fabrique de composant DbtPlyHdtManager
//////////////////////////////////////////////////////////////////////////
static ComponentFactory<DbtPlyHdtManager> sFactory("DbtPlyHdtManager");

// double dist1[2];
// double dist2[2];

//////////////////////////////////////////////////////////////////////////
// Constructor
//////////////////////////////////////////////////////////////////////////
DbtPlyHdtManager::DbtPlyHdtManager(QString name)
    : DbtPlyFileManager (name)
{

}

//////////////////////////////////////////////////////////////////////////
// Destructor
DbtPlyHdtManager::~DbtPlyHdtManager()
{

}

//////////////////////////////////////////////////////////////////////////
// Processes data
void DbtPlyHdtManager::processData(road_time_t t, road_timerange_t tr , void * buf)
{
    val = (trame_hdt*)(buf);

    // make local copy of VTG frame
    memcpy(&mHdt.frame, val, sizeof(trame_hdt));
    mHdt.time = t;
    mHdt.timerange = tr;

    // send HDT data to output
    checkedSend(outHdt, mHdt);

}

ComponentBase::COMPONENT_CONFIGURATION DbtPlyHdtManager::configureComponent(XmlComponentConfig config)
{
    DbtPlyFileManager::configureComponent(config);

    return ComponentBase::CONFIGURED_OK;
}

void DbtPlyHdtManager::startActivity()
{
  DbtPlyFileManager::startActivity();
  outHdt = getTypedOutput<TimestampedHdtFrame, DbtPlyHdtManager>("hdt");
  // user interface
}

void DbtPlyHdtManager::stopActivity()
{
  DbtPlyFileManager::stopActivity();
}


/************************************************************************
 * Called by the framework at initialization
 ************************************************************************/
void DbtPlyHdtManager::addInputs()
{
  // uncomment to add an input
}


/************************************************************************
 * Called by the framework at initialization
 ************************************************************************/
void DbtPlyHdtManager::addOutputs()
{
  // empty: no output
  addOutput<TimestampedHdtFrame, DbtPlyHdtManager>("hdt");
}
} // namespace pacpus
