//0/ Includes, project.
#include "WebcamWorker.hpp"

// Includes, qt.
#include <QDebug>

// Includes, standard.
#include <cassert>
#include <stdexcept>

using namespace pacpus;

WebcamWorker::WebcamWorker()
{
  mHeartbeat = new QTimer(this);
}

WebcamWorker::~WebcamWorker()
{
  close();
}

void
WebcamWorker::open(int device, int width, int height, int msec)
{
  if (!mWebcam.open(device))
    throw std::runtime_error("cannot open the requested device");
#ifdef WIN32
  if (!mWebcam.set(CV_CAP_PROP_FRAME_WIDTH, width))
    throw std::runtime_error("cannot set the requested width");
  if (!mWebcam.set(CV_CAP_PROP_FRAME_HEIGHT, height))
    throw std::runtime_error("cannot set the requested height");
#endif

  mHeartbeat->setInterval(msec);
  connect(mHeartbeat, SIGNAL(timeout()), this, SLOT(retrieveFrame()));
}

void
WebcamWorker::close()
{
  disconnect(mHeartbeat, SIGNAL(timeout()), this, SLOT(retrieveFrame()));
  mWebcam.release();
}

void
WebcamWorker::retrieveFrame()
{
  if (mWebcam.isOpened())
  {
    mWebcam >> mFrame;
    if (mFrame.data)
      emit gotFrame(mFrame);
  }
}

void
WebcamWorker::setup()
{
  mHeartbeat->start();
}

void
WebcamWorker::cleanup()
{
}
