#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

# ========================================
# Output
# ========================================
set(PACPUS_DEFINITIONS "")
set(PACPUS_DEPENDENCIES_INC "")
set(PACPUS_DEPENDENCIES_LIB "")

if(NOT QT5)
    find_package(Qt4)
    if(NOT QT4_FOUND)
        message(WARNING "Qt4 not found try to find Qt5")
        set(QT5 TRUE)
    endif()
endif()

if(QT5)
message(STATUS "Set CMake variable 'CMAKE_PREFIX_PATH' to the path like '%QT_BIN%/../lib/cmake'")
# ========================================
# All the Pacpus modules depend on Qt5
# However, since each module requires specific Qt's modules, they have to include their own QT_USE_FILE
# ========================================

# Tell CMake to run moc when necessary:
#set(CMAKE_AUTOMOC ON)
# As moc files are generated in the binary dir, tell CMake
# to always look for includes there:
set(CMAKE_INCLUDE_CURRENT_DIR ON)

find_package(Qt5Widgets REQUIRED)
find_package(Qt5Core REQUIRED)
find_package(Qt5Xml REQUIRED)
find_package(Qt5Gui REQUIRED)
find_package(Qt5OpenGL REQUIRED)
find_package(Qt5Network REQUIRED)
find_package(Qt5SerialPort REQUIRED)

set(QT_DEFINITIONS
    ${Qt5Widgets_DEFINITIONS}
    ${Qt5Core_DEFINITIONS}
    ${Qt5Xml_DEFINITIONS}
    ${Qt5Gui_DEFINITIONS}
    ${Qt5OpenGL_DEFINITIONS}
    ${Qt5Network_DEFINITIONS}
    ${Qt5SerialPort_DEFINITIONS}
)
set(QT_INCLUDE_DIR
    ${Qt5Widgets_INCLUDE_DIRS}
    ${Qt5Core_INCLUDE_DIRS}
    ${Qt5Xml_INCLUDE_DIRS}
    ${Qt5Gui_INCLUDE_DIRS}
    ${Qt5OpenGL_INCLUDE_DIRS}
    ${Qt5Network_INCLUDE_DIRS}
    ${Qt5SerialPort_INCLUDE_DIRS}
)

set(QT_LIBRARIES
    ${Qt5Widgets_LIBRARIES}
    ${Qt5Core_LIBRARIES}
    ${Qt5Xml_LIBRARIES}
    ${Qt5Gui_LIBRARIES}
    ${Qt5OpenGL_LIBRARIES}
    ${Qt5Network_LIBRARIES}
    ${Qt5SerialPort_LIBRARIES}
)

if(Qt5_POSITION_INDEPENDENT_CODE)
  set(CMAKE_POSITION_INDEPENDENT_CODE ON)
endif()

else(QT5)

# ========================================
# All the Pacpus' modules depends from Qt4
# However, since each module requires specific Qt's modules, they have to include their own QT_USE_FILE
# ========================================
find_package(Qt4 REQUIRED)

endif(QT5)

# ========================================
# Boost
# Do not use compiled modules, include-only headers.
# ========================================
#find_package(Boost 1.49.0 REQUIRED)
#list(APPEND PACPUS_DEPENDENCIES_INC ${Boost_INCLUDE_DIRS})

# ========================================
# log4cxx
# ========================================
if(PACPUS_USE_LOG)

    if(WIN32 AND MSVC AND IS_BUILDING_PACPUS)
        set(LOG4CXX_ROOT ${PACPUS_3RD_PARTY_DIR}/apache-log4cxx)
    endif()

    find_package(log4cxx REQUIRED)

    list(APPEND PACPUS_DEFINITIONS " -DPACPUS_USE_LOG ")
    list(APPEND PACPUS_DEPENDENCIES_INC ${LOG4CXX_INCLUDE_DIRS})
    list(APPEND PACPUS_DEPENDENCIES_LIB ${LOG4CXX_LIBRARIES})

    # If needed, install the dll of log4cxx
    if(WIN32 AND MSVC AND IS_BUILDING_PACPUS)
        pacpus_get_msvc(MSVC_VERSION)
        pacpus_purge_backslash(LOG4CXX_ROOT)

        install(
            FILES
                ${LOG4CXX_ROOT}/bin/${MSVC_VERSION}/log4cxx.dll
                ${LOG4CXX_ROOT}/bin/${MSVC_VERSION}/log4cxx_d.dll
            DESTINATION
                ${PACPUS_INSTALL_DIR}/bin
        )
    endif()
endif()

# ========================================
# Doxygen
# ========================================
if(PACPUS_BUILD_DOC)
    find_package(Doxygen)
    if(NOT DOXYGEN_FOUND)
        message(FATAL_ERROR "Doxygen is needed to build the documentation. Please install it correctly")
    endif()
endif()
