#include "Display.h"
#include <iostream>
#include <lib3dv-1.2.0/lib3dv/device.h>
#include <QMetaType>
#include "VislabImageProcessor.h"

Display::Display(const QString& windowName, lib3dv::image::type::types imageType) : VislabImageProcessor(windowName, imageType)
{
    qRegisterMetaType<cv::Mat>("cv::Mat");
    connect(this, SIGNAL(doDisplay(cv::Mat)),SLOT(DisplayFrame(cv::Mat)));

}

void Display::DisplayFrame(cv::Mat const& frame)
{
    cv::imshow(getName().toStdString(), frame);
}

void Display::process(cv::Mat const& frame)
{
    emit doDisplay(frame);;
}










