
// Includes, project.
#include "VislabComponent.hpp"
#include "VislabCamera.hpp"

// Includes, pacpus.
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include </home/louis/dev/pacpus/pacpusframework/include/Pacpus/kernel/DbiteException.h>
//#include <lib3dv-1.2.0/lib3dv/device.h>
#include <20150310_lib3dv-1.2.0/src/display.h>

// Includes, qt.
#include <QDir>
#include <QMetaType>

// Includes, standard.
#include <stdexcept>

#include <boost/asio/io_service.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

using namespace pacpus;

// Declare the logger and register the new component.
//DECLARE_STATIC_LOGGER("pacpus.component.vislabCamera")
//REGISTER_COMPONENT(VislabComponent, "Camera");

ComponentFactory<VislabComponent> sFactory("VislabComponent");

VislabComponent::VislabComponent(QString const& name)
    :ComponentBase(name),
    camera(name)
{

}

VislabComponent::~VislabComponent()
{


}

void
VislabComponent::stopActivity()
{
  camera.close();
}

void
VislabComponent::startActivity()
{
  camera.open();
  
  try
  {
    QString filename = name() + ".dbt";
    //mDBTFile.open(filename.toStdString(), WriteMode, FILE_JPEG,MAX_LENGTH_NAME);
  }
  catch (std::exception const& e)
  {
    LOG_ERROR(e.what());
  }

  
}

ComponentBase::COMPONENT_CONFIGURATION
VislabComponent::configureComponent(XmlComponentConfig config)
{
  try
  {
    QDir directory;
    if (!directory.exists(name().toLatin1()) && !directory.mkdir(name().toLatin1()))
      throw std::runtime_error("cannot create the webcam directory");

    //mFilenameTemplate = QString("%1/image-%2.jpg").arg(name());
    //LOG_INFO("template filename: " << mFilenameTemplate);
  }
  catch (std::exception const& e)
  {
    LOG_ERROR(e.what());
    return ComponentBase::CONFIGURED_FAILED;
  }

  return ComponentBase::CONFIGURED_OK;
}

void VislabComponent::addOutputs()
{
    // Transformer en QImage
    //addOutput<lib3dv::image, VislabComponent("image");
}



