#ifndef DISPLAY_H
#define DISPLAY_H

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <string.h>

// Includes, qt.
#include <QTimer>
#include <QObject>

// Includes, lib3dv.
#include <lib3dv-1.2.0/lib3dv/device.h>
//#include "20150310_lib3dv-1.2.0/src/disk_writer.h"
#include "DiskWriter.h"

#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/address.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

// Includes, opencv.
#include <opencv/cv.h>
#include <opencv/highgui.h>

class Display : public QObject, public VislabImageProcessor
{

    Q_OBJECT
public:
    Display(const QString& windowName, lib3dv::image::type::types imageType);
    void process(cv::Mat const& frame);
    Q_SLOT void DisplayFrame(cv::Mat const& frame);


private:
  /// Display a frame.

  Q_SIGNAL void doDisplay(cv::Mat const& frame);
  lib3dv::image::type::types mImageType;
  std::string mWindowName;
};

#endif // DISPLAY_H

