/*********************************************************************
//  created:    2008/2/11 - 12:01
//  filename:   Win32CanInterface.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Management of the Can Interface
//
*********************************************************************/

#ifndef WIN32CANINTERFACE_H
#define WIN32CANINTERFACE_H

// we use the Vector driver
#ifdef WIN32
//#   define CAN_DRIVER_TYPE       VECTOR_CAN_DRIVER 
#   define CAN_DRIVER_TYPE       VECTOR_CANXL_DRIVER 
//#   define CAN_DRIVER_TYPE       PEAK_CAN_DRIVER_WIN
//#   define CAN_DRIVER_TYPE         KVASER_CAN_DRIVER_WIN
#else
//#   define CAN_DRIVER_TYPE       IGEP_CAN_DRIVER
#   define CAN_DRIVER_TYPE         KVASER_CAN_DRIVER_WIN
#endif

#include <iostream>
#include <qsemaphore.h>
#include <qthread.h>

#include "CanDecoderBase.h"

#include "driver/CanDriver.h"
#include "structureCan.h"

namespace pacpus {

// class ShMem; // runtime crash because PosixShMem

class Win32CanInterface
    : public QThread
{
public:
  Win32CanInterface(); 
  ~Win32CanInterface();

  enum DataSource {VectorCard, SharedMemory, PeakCard, XLVectorCard, igepCard, KvaserCard};

  bool openInterface(const int number, const unsigned int speed);
  bool openInterface(char* port, char* accessMode);
  bool closeInterface(const int number);
  void stop();

  void setSignalSempahore(QSemaphore * semaphore) { semaphore_ = semaphore;};
  void setExchangeBuffer(TimestampedCanFrame * framesArray, const int framesArraySize);
  void setSource(DataSource source);
  CanDriver * canDriver_;
protected:
  void run(); 

  //void shMemLoop(); // runtime crash because PosixShMem
  void defaultLoop();


private:
  CanFrame frame_;
  bool continue_;
  DataSource source_;

  QSemaphore *semaphore_;
  TimestampedCanFrame * receivedFrames_;
  int receivedFramesArraySize_;

  // ShMem * shMem_; // runtime crash because PosixShMem

  int counter_;
};

} // namespace pacpus

#endif // WIN32CANINTERFACE_H
