#ifndef PACPUS_EVENT_H
#define PACPUS_EVENT_H

#include <QEvent>
#include "Pacpus/kernel/road_time.h"
#include <Pacpus/kernel/pacpus.h>
#include <QDataStream>

namespace pacpus {

// registerEventType // TODO

class GenericData {
public:
    GenericData(char* data, size_t size) {
        data_ = (char*)malloc(size);
        memcpy(data_,data,size);
        _size = size;}

    ~GenericData() {free(data_);}

    char * data() { return data_;}
    size_t size() {return _size;}

private:
char* data_;
size_t _size;
};

enum PacpusEventType  {
    TYPED_EVENT = 1000,
    GENERIC_EVENT = 2000,
    GENERIC_EVENT2 = 2002,
    GENERIC_EVENT3 = 2003,
    CONFIG_EVENT = 3000
};

class PACPUSLIB_API PacpusEvent
    : public QEvent
{
    Q_GADGET // permits to use signals and slots (using Q_SIGNAL, Q_SLOT) without inheriting from QObject

public:
    PacpusEvent(PacpusEventType type, road_time_t t = road_time(), road_timerange_t tr = 0):QEvent(QEvent::Type(type)),t_(t),tr_(tr) {}
    virtual ~PacpusEvent() {}

    virtual QDataStream& streamOut(QDataStream& out) {return out;}; // NOTE virtual pure ??
    virtual QDataStream& streamIn(QDataStream& in) {return in;};

public: // TODO make protected
    road_time_t t_;
    road_timerange_t tr_;
};

template<class T>
class PacpusTypedEvent : public PacpusEvent
{
public:
    PacpusTypedEvent(PacpusEventType type, T data = T(), road_time_t t = road_time(), road_timerange_t tr = 0 ):PacpusEvent(type, t, tr),data_(data) {}
    ~PacpusTypedEvent() {}

    QDataStream& streamOut(QDataStream& out) {return out << (quint64)t_ << tr_ /*<<data_*/;} // FIXME Stream Data errors
    QDataStream& streamIn(QDataStream& in) {return in >> (quint64&)t_ >> tr_ /*>> data_*/;}

public: // TODO make protected
    T data_;
};

class PACPUSLIB_API PacpusGenericEvent : public PacpusEvent
{
public:
    PacpusGenericEvent(PacpusEventType type, char* data, size_t size):PacpusEvent(type) {
        data_ = (char*)malloc(size);
        memcpy(data_,data,size);
        _size = size;

    }
    virtual ~PacpusGenericEvent() {free(data_);}
    char* data_;
    size_t _size;
};


} // namespace pacpus

inline QDataStream& operator << (QDataStream& out, pacpus::PacpusEvent& ev) {/*return ev.streamOut(out);*/ return out;}
inline QDataStream& operator >> (QDataStream& in, pacpus::PacpusEvent& ev) {/*return ev.streamIn(in);*/ return in;}

#endif // PACPUS_EVENT_H
