#include "DiskWriter.h"
#include <iostream>
#include <lib3dv-1.2.0/lib3dv/device.h>
#include <QDir>
#include <QFile>

const int MAX_LENGTH_NAME = 512;

    /*! A more elaborate description of the constructor*/
    DiskWriter::DiskWriter(const QString name, lib3dv::image::type::types imageType) : VislabImageProcessor(name, imageType)
    {
        QDir directory;
        /*! For the classic picture */
        if (imageType == lib3dv::image::type::RIGHT_RECTIFIED)
        {
            QString nameBase = getName() + "_Video";
            if (!directory.exists(nameBase.toLatin1()) && !directory.mkdir(nameBase.toLatin1()))
              throw std::runtime_error("cannot create the webcam directory");
            mFilenameTemplate = nameBase + QString("/image-%1.png");
            mDbtfilename = nameBase + ".dbt";
            mDBTFile.open(mDbtfilename.toStdString(), WriteMode, FILE_JPEG, MAX_LENGTH_NAME);
            mImageCounter = mDBTFile.getRecordCount();

        }
        /*! For the disparity picture */
        if (imageType == lib3dv::image::type::DSI)
        {
            QString nameBase = getName() + "_Disparite";
            if (!directory.exists(nameBase.toLatin1()) && !directory.mkdir(nameBase.toLatin1()))
              throw std::runtime_error("cannot create the webcam directory");
            mFilenameTemplate = nameBase + QString("/image-%1.png");
            mDbtfilename = nameBase + ".dbt";
            mDBTFile.open(mDbtfilename.toStdString(), WriteMode, FILE_JPEG, MAX_LENGTH_NAME);
            mImageCounter = mDBTFile.getRecordCount();
        }
    }

    /*! process function from the DiskWriter class with a cv:Mat parameter */
    void DiskWriter::process(cv::Mat const& frame)
    {
        try
        {
          QString filename = mFilenameTemplate.arg(mImageCounter);
          //std::cout << mFilenameTemplate << std::endl;
          ++mImageCounter;

        if (!cv::imwrite(filename.toStdString(), frame))
          throw std::runtime_error("cannot save the following frame: " + filename.toStdString());

        /*! Write of the file on the disk */
        mDBTFile.writeRecord(road_time(), 0, filename.toStdString().c_str(), MAX_LENGTH_NAME);
      }
      catch (DbiteException & e)
      {
        LOG_ERROR("error writing data: " << e.what());
      }
    }


