#ifndef DEF_VISLAB_CAMERA_HPP
#define DEF_VISLAB_CAMERA_HPP

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/InputOutputInterface.h>

// Includes, qt.
#include <QTimer>

// Includes, lib3dv.
#include <lib3dv-1.2.0/lib3dv/device.h>
#include <lib3dv-1.2.0/lib3dv/error.h>
#include "DiskWriter.h"
#include "Display.h"
#include "VislabImageProcessor.h"
#include "Outputter.h"
#include "VislabComponent.hpp"

#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/address.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

namespace pacpus
{
  class VislabCamera
    //: public pacpus::AsyncWorkerBase
  {
    //Q_OBJECT
    public:
      /// Ctor of VislabCamera.
      VislabCamera(const QString& name);

      /// Dtor of VislabCamera.
      virtual ~VislabCamera();

      /// Open a webcam.
      void open();

      /// Close the webcam.
      void close();

	  void setVideoOutput(OutputInterface<cv::Mat, VislabComponent>* output);
	  void setDispariteOutput(OutputInterface<cv::Mat, VislabComponent>* output);

      std::vector<lib3dv::device> curr_devices;
      DiskWriter diskwriterVideo;
      DiskWriter diskwriterDisparite;
      Display displayVideo;
      Display displayDisparite;
      lib3dv::error error;
      unsigned int log_level;
      lib3dv::image::type imageType;
	  Outputter outputVideo;
	  Outputter outputDisparite;

  };
}

#endif
