#ifndef _3DV_DISK_WRITER_H
#define _3DV_DISK_WRITER_H

/* 3dv-client/disk_writer.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "file.h"

#include <boost/asio/io_service.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/thread/thread.hpp>
#include <boost/filesystem.hpp>
#include <iostream>
#include <fstream>

#include <string>
#include <vector>

#include <stdint.h>

#ifdef ARCHIVE
    class archive;
#endif

class disk_writer
{
    public:
        
        disk_writer(const std::vector<boost::filesystem::path>& paths, data_file_format::types data_file_format, bool autonumber, device_params params, uint8_t guid_type, uint8_t log_level);

#ifdef ARCHIVE
        disk_writer(const std::vector<boost::filesystem::path>& paths, const std::string& archive_name, archive_file_format::types archive_format, data_file_format::types data_file_format, bool autonumber, device_params params, uint8_t guid_type, uint8_t log_level);
#endif

        void image_callback(boost::shared_ptr<const lib3dv::image> image, uint32_t guid);
        
        void terrain_callback(boost::shared_ptr<const lib3dv::terrain> terrain, uint32_t guid);
        
        void obstacles_callback(boost::shared_ptr<const std::vector<lib3dv::obstacle> > obstacles, uint32_t guid);

        void motion_callback(boost::shared_ptr<const lib3dv::motion> pose, uint32_t guid);

        void classification_callback(boost::shared_ptr<const lib3dv::classification> classification, uint32_t guid);

        void run();
        
        void stop();
        
    private:
        
        struct disk_queue
        {
            disk_queue(const boost::filesystem::path& path, data_file_format::types data_file_format, uint8_t log_level);
            
#ifdef ARCHIVE
            disk_queue(const boost::filesystem::path& path, const std::string& archive_name, archive_file_format::types archive_format, data_file_format::types data_file_format,device_params params, uint8_t log_level);
#endif

            ~disk_queue();

            boost::asio::io_service m_io_service;
            boost::asio::io_service::work* m_io_service_work;

            boost::filesystem::path m_path;
            data_file_format::types m_data_file_format;
#ifdef ARCHIVE
            archive* m_archive;
#endif
            uint8_t m_log_level;
        };
        
        bool m_autonumber;
        uint8_t m_log_level;
        uint8_t m_guid_type;
        std::vector<boost::shared_ptr<disk_queue> > m_disk_queues;
        boost::thread_group m_disk_queue_threads;
};

#endif
