#ifndef _3DV_DISPLAY_H
#define _3DV_DISPLAY_H

/* 3dv-client/display.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/calibration.h>
#include <lib3dv/image.h>
#include <lib3dv/motion.h>
#include <lib3dv/obstacle.h>
#include <lib3dv/classification.h>
#include <lib3dv/terrain.h>

#include <boost/array.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/thread/condition.hpp>
#include <boost/thread/mutex.hpp>

#include <stdint.h>

#include <bitset>
#include <string>
#include <utility>



namespace lib3dv { struct image; struct terrain; struct obstacle; struct pose; class inverse_perspective_mapping; class pose_utils; }
namespace pcl { namespace visualization { class ImageViewer; class PCLVisualizer; } }

class display
{
    public:
        
        display(const lib3dv::calibration::camera_intrinsics& intrinsics, const lib3dv::calibration::position& position, const lib3dv::calibration::orientation& orientation, float baseline, uint8_t downsample, double area_step, uint8_t log_level);
        
        void update(boost::shared_ptr<const lib3dv::image> image);

        void update(boost::shared_ptr<const lib3dv::terrain> terrain);

        void update(boost::shared_ptr<const std::vector<lib3dv::obstacle> > obstacles);
        
        void update(boost::shared_ptr<const lib3dv::motion> motion);

        void update(boost::shared_ptr<const lib3dv::classification > classification);

        void run();
        
        void stop();

        void toggle_points_display() { m_show_points = !m_show_points; }

        void toggle_terrain_display() { m_show_terrain = !m_show_terrain; }

        void toggle_terrain_gm_display() { m_show_terrain_gm = !m_show_terrain_gm; }

        void toggle_obstacles_display() { m_show_obstacles = !m_show_obstacles; }
        
        void toggle_motion_display() { m_show_motion = !m_show_motion; }

        void toggle_classification_display() { m_show_classification = !m_show_classification; }


    private:
        
        
        boost::shared_ptr<lib3dv::inverse_perspective_mapping> m_ipm;
        boost::shared_ptr<lib3dv::pose_utils> m_pose_utils;

        uint8_t m_downsample;
        uint8_t m_log_level;
        
        boost::array<boost::shared_ptr<pcl::visualization::ImageViewer>, lib3dv::image::type::NUM - 1> m_image_viewers;
        std::bitset<lib3dv::image::type::NUM - 1> m_image_viewers_closed;
        boost::shared_ptr<pcl::visualization::PCLVisualizer> m_3d_viewer;
        bool m_3d_viewer_closed;
        
        boost::array<std::pair<boost::shared_ptr<const lib3dv::image>, boost::shared_ptr<const lib3dv::image> >, lib3dv::image::type::NUM - 1> m_image_buffers;
        std::pair<boost::shared_ptr<const lib3dv::terrain>, boost::shared_ptr<const lib3dv::terrain> > m_terrain_buffers;
        std::pair<boost::shared_ptr<const std::vector<lib3dv::obstacle> >, boost::shared_ptr<const std::vector<lib3dv::obstacle> > > m_obstacles_buffers;
        std::pair<boost::shared_ptr<const lib3dv::motion>, boost::shared_ptr<const lib3dv::motion> > m_motion_buffers;
        std::pair<boost::shared_ptr<const lib3dv::classification>, boost::shared_ptr<const lib3dv::classification> > m_classification_buffers;
        
        // 3d viewer stuff
        boost::shared_ptr<const lib3dv::image> m_dsi;
        boost::shared_ptr<const lib3dv::image> m_right_rectified;
        bool m_show_points;
        bool m_show_terrain;
        bool m_show_terrain_gm;
        bool m_show_obstacles;
        bool m_show_motion;
        bool m_show_classification;
        
        bool m_stopped;
        bool m_updated;
        boost::condition_variable m_update_condition;
        boost::mutex m_update_mutex;
        std::pair<lib3dv::calibration::orientation, lib3dv::calibration::orientation> m_me_orientations;
        std::pair<boost::posix_time::time_duration, boost::posix_time::time_duration> m_td_orientations;

        double m_area_step;

        int screen_width;
        int screen_height;
};

#endif
