#ifndef _3DV_UTILS_H
#define _3DV_UTILS_H

/* 3dv-client/utils.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "file.h"

#include <lib3dv/image.h>
#include <lib3dv/terrain.h>
#include <lib3dv/obstacle.h>
#include <lib3dv/classification.h>


#include <boost/asio/ip/address.hpp>
#include <boost/asio/io_service.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/function.hpp>
#include <boost/thread/condition_variable.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/thread.hpp>

#include <vector>

std::vector<boost::asio::ip::address> list_interface_addresses();

#ifdef PCL
class display;

void image_callback_display(boost::shared_ptr<const lib3dv::image> image, uint32_t guid, display& display, uint8_t log_level);

void terrain_callback_display(boost::shared_ptr<const lib3dv::terrain> terrain, uint32_t guid, display& display, uint8_t log_level);

void obstacles_callback_display(boost::shared_ptr<const std::vector<lib3dv::obstacle> > obstacles, uint32_t guid, display& display, uint8_t log_level);

void motion_callback_display(boost::shared_ptr<const lib3dv::motion> motion, uint32_t guid, display& display, uint8_t log_level);

void classification_callback_display(boost::shared_ptr<const lib3dv::classification> classificat, uint32_t guid, display& display, uint8_t log_level);
#endif

class disk_writer;

#ifdef PCL
void signal_handler(const boost::system::error_code& error, int signal_number, boost::shared_ptr<disk_writer>& disk_writer, boost::shared_ptr<display>& display, boost::asio::io_service& sighandler);
void timeout_callback(boost::shared_ptr<disk_writer>& disk_writer, boost::shared_ptr<display>& display, boost::asio::io_service& sighandler);
#else
void signal_handler(const boost::system::error_code& error, int signal_number, boost::shared_ptr<disk_writer>& disk_writer, boost::asio::io_service& sighandler);
void timeout_callback(boost::shared_ptr<disk_writer>& disk_writer, boost::asio::io_service& sighandler);
#endif


#endif
