#ifndef CANDIDATE_H_
#define CANDIDATE_H_


/* lib3dv/candidate.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <stdint.h>
#include <lib3dv/point.h>

namespace lib3dv
{

    /**
     * @brief Possible category types.
    **/
    struct category_type
    {
        enum types
    {   
            UNKNOWN=0,       ///< Unknow category.
            PEDESTRIAN,      ///< Pedestrian category, blue rectangle in the client display.
            CAR,             ///< Car category, red rectangle in the client display.
            NUM
        };
    };

    /**
     * @brief A candidate detected by the device.
     *
     *  A candidate is defined by a rectangle in the right image coordinate.
     */
    struct candidate
    {
        uint32_t m_guid;     ///< Unique ID associated with the candidate in the current frame.
        uint16_t m_x0;       ///< x coordinate of the upper left rectangle corner in the right image.
        uint16_t m_y0;       ///< y coordinate of the upper left rectangle corner in the right image.
        uint16_t m_x1;       ///< x coordinate of the bottom right rectangle corner in the right image.
        uint16_t m_y1;       ///< y coordinate of the bottom right rectangle corner in the right image.
        float m_confidence;  ///< Confidence of the detection.
        point3 m_wp_lb;      ///< Candidate world position. The position is relative to the  bottom center point of the rectangle.   
        category_type::types m_category;  ///< Candidate Category. @see lib3dv::category_type::types
    };
}


#endif /* CANDIDATE_H_ */
