#ifndef LIB3DV_DETAIL_RAW_DATA_H
#define LIB3DV_DETAIL_RAW_DATA_H

/* lib3dv/detail/raw_data.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/detail/protocol.h>
#include <lib3dv/detail/protocol.h>

#include <boost/dynamic_bitset.hpp>

#include <stdint.h>

namespace lib3dv
{
    namespace detail
    {
        /**
         * @brief Convenience struct to reassemble some raw data.
         **/
        template<typename H>
        struct raw_data
        {
            H m_header;                             ///< Header.
            boost::dynamic_bitset<> m_fragments;    ///< Received fragments.
            std::vector<uint8_t>    m_buffer;       ///< Raw data buffer.
        };

        struct raw_data_fragment
        {
            protocol::data_header m_header;
            uint32_t m_fragment;
            uint32_t m_total_fragments;
            std::vector<uint8_t>  m_buffer;
        };
        
        typedef raw_data<protocol::image_info_header> raw_image_type;
        typedef raw_data<protocol::terrain_info_header> raw_terrain_type;
        typedef raw_data<protocol::obstacles_map_info_header> raw_obstacles_type;
        typedef raw_data<protocol::motion_info_header> raw_motion_type;
    }
}

#endif
 
 
