#ifndef LIB3DV_ERROR_H
#define LIB3DV_ERROR_H

/* lib3dv/error.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/3dv_export.h>

#include <ostream>

namespace lib3dv
{
    /**
     * @brief Structure representing an error condition.
     * 
     */    
    struct LIB3DV_EXPORT error
    {
        enum types
        {
            NONE = 0,
            PROPERTY_READONLY,      ///< Attempt to write a read-only property.
            PROPERTY_NOT_FOUND,     ///< Requested property is not available for the device.
            PROPERTY_TYPE_MISMATCH, ///< Attempted to set a property using the wrong type.
            PROPERTY_VALUE_INVALID, ///< Attempted to set a property using a value out of range.
            NETWORK_TIMEOUT,        ///< Network connection timed out.
            NETWORK_FAILURE,        ///< Network connection failure.
            DEVICE_NOT_FOUND,       ///< Requested device could not be found.
            DEVICE_INVALID          ///< An invalid device has been used.
        };
        
        /**
         * @brief Create an empty error.
         * 
         */
        error() : m_type(NONE) {}
        
        types m_type; ///< Error type. @see lib3dv::error::types.
        
        void operator= (const error::types& type) { m_type = type; }
        
        bool operator== (const error::types& type) { return m_type == type; }
        
        bool operator!= (const error::types& type) { return m_type != type; }
        
        operator int() { return static_cast<int>(m_type); }
        
        friend LIB3DV_EXPORT std::ostream& operator<< (std::ostream& output, const error& error);
    };
}

#endif
