#ifndef LIB3DV_POSE_H
#define LIB3DV_POSE_H

/* lib3dv/pose.h
 *
 * Copyright (C) 2014 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */


#include <boost/date_time/posix_time/posix_time.hpp>

#include <vector>

namespace lib3dv
{
    /**
    * @brief Pose data.
    *
    * The estimated pose is a 4x4 Matrix represented as a scalable array.
    */
    struct pose                    
    {   
        /**
        * @brief Pose type.
        */
        struct type              
        {   
            enum types         
            {
                CURRENT_POSE = 0,       ///< Absolute current pose
                RELATIVE_POSE           ///< Relative pose
            };
        };

        type::types m_type;                     ///< Pose type. @see lib3dv::pose::type
        boost::posix_time::ptime m_timestamp;   ///< Pose timestamp.
        std::vector<double> m_data;             ///< Pose array data.
    };
}

#endif
