#ifndef LIB3DV_TERRAIN_H
#define LIB3DV_TERRAIN_H

/* lib3dv/terrain.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/point.h>

#include <vector>

namespace lib3dv
{
    /**
     * @brief Terrain data.
     * 
     * The estimated terrain surface is sampled at a number of locations, and the resulting points are returned.
     */
    struct terrain
    {
        std::vector<point3> m_data; ///< The collection of 3D terrain samples.
    };
}

#endif
