#ifndef LIB3DV_CALIBRATION_H
#define LIB3DV_CALIBRATION_H

/* calibration.h
 * 
 * Copyright (C) 2014 VisLab
 * 
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */  

namespace lib3dv
{
    namespace calibration
    {
        /**
         * @brief Intrinsic camera calibration parameters.
         **/
        struct camera_intrinsics
        {   
            float m_u0;         ///< horizontal optical center [px].
            float m_v0;         ///< vertical optical center [px].
            float m_ku;         ///< horizontal focal length [px].
            float m_kv;         ///< vertical focal length [px].
        };

        /**
         * @brief Device position.
         **/
        struct position
        {
            float m_x;          ///< x [m].
            float m_y;          ///< y [m].
            float m_z;          ///< z [m].
        };

        /**
         * @brief Device orientation.
         **/    
        struct orientation
        {
            float m_yaw;        ///< yaw [rad].
            float m_pitch;      ///< pitch [rad].
            float m_roll;       ///< roll [rad].
        };
    }
}

#endif
