#ifndef LIB3DV_DETAIL_COMMAND_H
#define LIB3DV_DETAIL_COMMAND_H

/* lib3dv/command.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <boost/any.hpp>
#include <boost/asio.hpp>

#include <stdint.h>
#include <vector>

namespace lib3dv
{
    namespace detail
    {
        struct command
        {
            enum types
            {
                ENUMERATE_DEVICES = 0,
                START_TRANSMISSION,
                STOP_TRANSMISSION,
                RESET_PROPERTIES,
                ENUMERATE_PROPERTIES,
                SAVE_PROPERTIES,
                SET_PROPERTY,
                GET_PROPERTY,
                POWEROFF,
                REBOOT
            };
            
            enum values
            {
                BOOL = 0,
                INT64,
                INT32,
                INT16,
                INT8,
                UINT64,
                UINT32,
                UINT16,
                UINT8,
                FLOAT32,
                FLOAT64,
                STRING,
                NUM
            };
            
            enum categories
            {
                VALUE = 0,
                RANGE,
                SELECTION
            };

            types m_type;
            std::vector<uint8_t> m_data;
            boost::any m_result;
        };
    }
}

#endif
