/* lib3dv/error.cc
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/error.h>

namespace lib3dv
{
    std::ostream& operator<< (std::ostream& output, const error& error)
    {        
        switch(error.m_type)
        {
            case(error::NONE) :
            {
                output << "NONE";
                break;
            }

            case(error::PROPERTY_NOT_FOUND) :
            {
                output << "PROPERTY_NOT_FOUND";
                break;
            }

            case(error::PROPERTY_READONLY) :
            {
                output << "PROPERTY_READONLY";
                break;
            }
            
            case(error::PROPERTY_TYPE_MISMATCH) :
            {
                output << "PROPERTY_TYPE_MISMATCH";
                break;
            }
            
            case(error::PROPERTY_VALUE_INVALID) :
            {
                output << "PROPERTY_VALUE_INVALID";
                break;
            }
            
            case(error::NETWORK_TIMEOUT) :
            {
                output << "NETWORK_TIMEOUT";
                break;
            }
            
            case(error::NETWORK_FAILURE) :
            {
                output << "NETWORK_FAILURE";
                break;
            }
            
            default :                
                output << "UNKNOWN";
        }

        return output;
    }
}
