#ifndef LIB3DV_OBSTACLE_H
#define LIB3DV_OBSTACLE_H

/* lib3dv/obstacle.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <lib3dv/stixel.h>

#include <stdint.h>
#include <vector>

namespace lib3dv
{
    /**
     * @brief An obstacle detected by the device.
     * 
     */
    struct obstacle
    {
        uint32_t m_guid;            ///< Unique ID associated with the obstacle. Can be used for tracking.
        std::vector<stixel> m_data; ///< Obstacle data. @see lib3dv::stixel
    };
}

#endif
