#ifndef LIB3DV_STIXEL_H
#define LIB3DV_STIXEL_H

/* lib3dv/stixel.h
 *
 * Copyright (C) 2013 VisLab
 *
 * This file is part of lib3dv; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

namespace lib3dv
{
    /**
     * @brief An elementary obstacle part, corresponding to a vertical stick in the world.
     * 
     */
    struct stixel
    {
        float m_x;      ///< Base X coordinate.
        float m_y;      ///< Base Y coordinate.
        float m_z;      ///< Base Z coordinate.
        float m_height; ///< Stick height.
        float m_dx;     ///< Stick size along the X axis.
        float m_dy;     ///< Stick size along the Y axis.
    };
}

#endif
 
