#ifndef IN_OUT_BASE_H
#define IN_OUT_BASE_H

#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/ConnectionBase.h>
#include <Pacpus/kernel/PacpusEvent.h>

#include <QApplication>
#include <typeinfo>
#include <QList>
#include <QStringList>

namespace pacpus {

class ComponentBase;

class PACPUSLIB_API AbstractInterface : public QObject
{
     Q_OBJECT
protected:
    AbstractInterface(QString name, ComponentBase * component, QObject * parent = 0):_name(name),_component(component),QObject(parent) {}
    ~AbstractInterface(){}
public:
    QString getSignature();
    QString getName() {return _name;}
    virtual QString getDataType() = 0;
    ComponentBase * getComponent() {return _component;}

    void addConnection(ConnectionBase connection) { _connection.append(connection);}
    bool removeConnection(ConnectionBase connection) { return _connection.removeOne(connection);}

    bool hasConnection() { return _connection.size() > 0;}

protected:
    QString _name;
    ComponentBase * _component;
    QList<ConnectionBase> _connection;
};

class PACPUSLIB_API InputInterfaceBase : public AbstractInterface
{
    Q_OBJECT
protected:
    InputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0):AbstractInterface(name,component,parent) {}

public:
    //InputInterfaceBase(QString name, ComponentBase * component,int a, QObject * parent = 0):AbstractInterface(name,component,parent) {} // TODO add ctor with function pointer

	    enum ReadingMode {
        NeverSkip,
        TimeBounded,
        GetLast
    };

    virtual ~InputInterfaceBase(){}

    virtual void customEvent(QEvent* e) {

        //if(event->type())
            //TODO get event Type anf call callback function

            PacpusEvent * event = dynamic_cast<PacpusEvent *>(e);
    QByteArray buf;
    QDataStream out(&buf,QIODevice::WriteOnly);
    event->streamOut(out);
    // Callback QByteArray
    }

    void setReadingMode(ReadingMode mode) { readingMode_ = mode;}
    virtual PacpusEvent* getEventTemplate() {return new PacpusEvent(GENERIC_EVENT);} // TODO check ??
protected:
	    ReadingMode readingMode_;
private:
        // metode(QByteArray)

        //QQueue jobQueue_;
};

class PACPUSLIB_API OutputInterfaceBase: public AbstractInterface
{
    Q_OBJECT

public:
    OutputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0):AbstractInterface(name,component,parent) {}

    virtual ~OutputInterfaceBase(){}

    QStringList getInputConnectedList() {
        QStringList list;
        for(QList<ConnectionBase>::iterator it = _connection.begin(); it!=_connection.end(); ++it)
            list.append(it->getInterface()->getName());
        return list;
    }

    void send(/*const*/ QByteArray & data) {
        // TODO check at least one Typed connection

        for(QList<ConnectionBase>::iterator it = _connection.begin(); it!=_connection.end(); ++it){
                QDataStream in(&data,QIODevice::ReadOnly);
                PacpusEvent* event = dynamic_cast<InputInterfaceBase*>(_connection.at(0).getInterface())->getEventTemplate();
                event->streamIn(in);
                QApplication::postEvent(it->getInterface(),event,it->getPriority());
        }


    }

};

static bool connectInterface(OutputInterfaceBase* out, InputInterfaceBase * in, int priority, InputInterfaceBase::ReadingMode mode = InputInterfaceBase::GetLast)
{
    if(out->getDataType() == in->getDataType() || out->getDataType() == QString(typeid(QByteArray).name()) || in->getDataType() == QString(typeid(QByteArray).name())) {

        // Add connection
        out->addConnection(ConnectionBase(in,priority));  // TODO make connect function
        in->addConnection(ConnectionBase(out,priority));
        in->setReadingMode(mode);
        //LOG_INFO("connection : Output " << out->getSignature() << " => Input " << in->getSignature());
        return true;
    } else {
   //LOG_WARN("connecting " << out->getSignature() << ":" << out->getDataType() << " to " << in->getSignature() << ":" << in->getDataType() << " failled : DataType incompatible " <<  QString(typeid(QByteArray).name()));
   return false;
    }
}

} // namespace pacpus

#endif // IN_OUT_BASE_H
