#include "Outputter.h"
#include <iostream>
#include <lib3dv-1.2.0/lib3dv/device.h>
#include <QMetaType>
#include "VislabImageProcessor.h"

/*! A more elaborate description of the constructor*/
Outputter::Outputter(lib3dv::image::type::types imageType) : VislabImageProcessor("", imageType), output_(0)
{
}

void Outputter::setOutput(pacpus::OutputInterface<cv::Mat, pacpus::VislabComponent>* output)
{
	output_ = output;
}

/*! process function from the Outputter class with a cv:Mat parameter
Emit the signal to send the frame
*/
void Outputter::process(cv::Mat const& frame)
{
	if (output_ && output_->hasConnection())
	{ 
		output_->send(frame);
	}

}










