#ifndef DEF_CAMERA_VIEWER_COMPONENT_HPP
#define DEF_CAMERA_VIEWER_COMPONENT_HPP


// Includes, qt.
#include <QTimer>
#include <QObject>

// Includes, pacpus.
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/pacpus.h>

// Includes, opencv.
#include <opencv2/opencv.hpp>
#include <opencv2/highgui.hpp>


#ifdef WIN32
#   ifdef CAMERA_VIEWER_COMPONENT_EXPORTS
#       define CAMERA_VIEWER_COMPONENT_API __declspec(dllexport)
#   else
#       define CAMERA_VIEWER_COMPONENT_API __declspec(dllimport)
#   endif
#else
#   define CAMERA_VIEWER_COMPONENT_API
#endif

namespace pacpus
{
  class CAMERA_VIEWER_COMPONENT_API CameraViewerComponent
    : public QObject
    , public ComponentBase
  {
    Q_OBJECT
    public:

      //device(){}
      /// Ctor of CameraViewerComponent.
		//CameraViewerComponent(const QString& windowName, lib3dv::image::type::types imageType);

		CameraViewerComponent(QString const& name);

		/// Dtor of CameraViewerComponent
          ~CameraViewerComponent();

      /// Stop the processing thread.
      virtual void stopActivity();

      /// Start the processing thread.
      virtual void startActivity();

      /// Configure the component.
      virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
	  void process(cv::Mat const& frame);

      // Working thread, grabbing frame from a webcam.
      DbiteFile mDBTFile;

    public:
      virtual void addInputs();

      private:
    std::string mOutputFileName;
    Q_SIGNAL void doDisplay(cv::Mat const& frame);
	Q_SLOT void DisplayFrame(cv::Mat const& frame);
  };
}

#endif
