#ifndef DEF_VISLAB_COMPONENT_HPP
#define DEF_VISLAB_COMPONENT_HPP

// Includes, project.
#include "VislabCamera.hpp"

// Includes, qt.
#include <QObject>

// Includes, pacpus.
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/pacpus.h>

#include <lib3dv/device.h>

#include <opencv2/opencv.hpp>
#include <opencv2/highgui.hpp>

#ifdef WIN32
#   ifdef VISLAB_COMPONENT_EXPORTS
#       define VISLAB_COMPONENT_API __declspec(dllexport)
#   else
#       define VISLAB_COMPONENT_API __declspec(dllimport)
#   endif
#else
#   define VISLAB_COMPONENT_API
#endif

namespace pacpus
{
  class VISLAB_COMPONENT_API VislabComponent
    : public QObject
    , public ComponentBase
  {
    Q_OBJECT
    public:

      //device(){}
      /// Ctor of VislabComponent.
      VislabComponent(QString const& name);

	  /// Dtor of VislabComponent
	  ~VislabComponent();

      /// Stop the processing thread.
      virtual void stopActivity();

      /// Start the processing thread.
      virtual void startActivity();

      /// Configure the component.
      virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    public:
      virtual void addOutputs();

      private:
    std::string mOutputFileName;

  protected:
    VislabCamera camera;

  };
}

#endif
