
// Includes, project.
#include "VislabComponent.hpp"
#include "VislabCamera.hpp"

// Includes, pacpus.
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include <Pacpus/kernel/DbiteException.h>
#include <lib3dv/device.h>
//#include <20150310_lib3dv-1.2.0/src/display.h>

// Includes, qt.
#include <QDir>
#include <QMetaType>

// Includes, standard.
#include <stdexcept>

#include <boost/asio/io_service.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

using namespace pacpus;

// Declare the logger and register the new component.
//DECLARE_STATIC_LOGGER("pacpus.component.vislabCamera")
//REGISTER_COMPONENT(VislabComponent, "Camera");

ComponentFactory<VislabComponent> sFactory("VislabComponent");

VislabComponent::VislabComponent(QString const& name)
    :ComponentBase(name),
    camera(name)
{

}

VislabComponent::~VislabComponent()
{


}

void
VislabComponent::stopActivity()
{
  camera.close();
}

void
VislabComponent::startActivity()
{
  camera.open();
  
  try
  {
	camera.setVideoOutput(getTypedOutput<cv::Mat, VislabComponent>("image"));
	camera.setDispariteOutput(getTypedOutput<cv::Mat, VislabComponent>("disparity"));
  }
  catch (std::exception const& e)
  {
    LOG_ERROR(e.what());
  }

  
}

ComponentBase::COMPONENT_CONFIGURATION
VislabComponent::configureComponent(XmlComponentConfig config)
{
  return ComponentBase::CONFIGURED_OK;
}

void VislabComponent::addOutputs()
{
    addOutput<cv::Mat, VislabComponent>("image");
	addOutput<cv::Mat, VislabComponent>("disparity");
}



