// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    March, 2012
/// @version $Id: Log.h 73 2013-01-10 16:56:42Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Logging facility.
///
/// Detailed description.

#ifndef DEF_PACPUS_LOG_H
#define DEF_PACPUS_LOG_H

// Includes, pacpus.
#include <Pacpus/kernel/pacpus.h>

namespace pacpus {

/// Static log facility initializer
///
/// Uses Schwarz counter (nifty counter) idiom to initialize the log before
/// other static objects that could use the log.
static class PACPUSLIB_API LogConfigurator
{
public:
    LogConfigurator();
    ~LogConfigurator();
    static void configureLoggerWithFile(const char * configFilename);
} logInitializer;

} // namespace pacpus

#if defined(PACPUS_USE_LOG)

#include <boost/log/trivial.hpp>
#include <iosfwd>
class QString;

template< typename CharT, typename TraitsT >
PACPUSLIB_API std::basic_ostream< CharT, TraitsT >& operator<< (std::basic_ostream< CharT, TraitsT >& strm, QString const& s);

#define DECLARE_STATIC_LOGGER(name) 

#define LOG(level, message)         BOOST_LOG_TRIVIAL(level) << message
#define LOG_TRACE(message)          LOG(trace, message)
#define LOG_DEBUG(message)          LOG(debug, message)
#define LOG_INFO(message)           LOG(info, message)
#define LOG_WARN(message)           LOG(warning, message)
#define LOG_ERROR(message)          LOG(error, message)
#define LOG_FATAL(message)          LOG(fatal, message)

#else

/// @param name Name of the logger, displayed when logging a message.
#define DECLARE_STATIC_LOGGER(name)
/// Logs a message at TRACE level using default logger
#define LOG_TRACE(message)
/// Logs a message at DEBUG level using default logger
#define LOG_DEBUG(message)
/// Logs a message at INFO level using default logger
#define LOG_INFO(message)
/// Logs a message at WARN level using default logger
#define LOG_WARN(message)
/// Logs a message at ERROR level using default logger
#define LOG_ERROR(message)
/// Logs a message at FATAL level using default logger
#define LOG_FATAL(message)

#endif // PACPUS_USE_LOG

#endif // DEF_PACPUS_LOG_H
