 // Includes, project.
#include "VislabCamera.hpp"

// Includes, qt.imageformat
#include <QDebug>

// Includes, standard.
#include <cassert>
#include <stdexcept>

// Includes lib3dv
#include <lib3dv/device.h>
#include "DiskWriter.h"
#include "Display.h"
#include "VislabImageProcessor.h"

#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/address.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

using namespace pacpus;

//ComponentFactory<VislabCamera> sFactory("VislabComponent");
/*! Constructor with 2 instantiations of DiskWriter and 2 instatiations of Display*/
    VislabCamera::VislabCamera(const QString& name)
     :diskwriterVideo(name,lib3dv::image::type::RIGHT_RECTIFIED),
     diskwriterDisparite(name,lib3dv::image::type::DSI),
     displayVideo("Video",lib3dv::image::type::RIGHT_RECTIFIED),
     displayDisparite("Disparite",lib3dv::image::type::DSI),
	 outputVideo(lib3dv::image::type::RIGHT_RECTIFIED),
	 outputDisparite(lib3dv::image::type::DSI)
{

}

VislabCamera::~VislabCamera()
{

}

void VislabCamera::open()
{
    curr_devices = lib3dv::device::enumerate(boost::asio::ip::address_v4::from_string("192.168.0.2"), 0);
	if (error != lib3dv::error::NONE)
	{
		std::cout << "[EE] 3dv-client: error detected: " << error << std::endl;
		return;
	}

    if(curr_devices.empty())
    {
        std::cout << "[EE] 3dv-client: no devices found" << std::endl;
		return;
        //return lib3dv::error::NONE;
    }
      //disk_writer = boost::shared_ptr< ::disk_writer>(new ::disk_writer(paths, data_format, autonumber, params, guid_type, log_level));

    //curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &displayVideo, _1)));
    //curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &displayDisparite, _1)));
    curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &diskwriterVideo, _1)));
    curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &diskwriterDisparite, _1)));
	curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &outputVideo, _1)));
	curr_devices[0].connect_image_callback(boost::function<void(boost::shared_ptr< const lib3dv::image>)>(boost::bind(&::VislabImageProcessor::image_callback, &outputDisparite, _1)));
	curr_devices[0].start_transmission(false);
    if(error != lib3dv::error::NONE)
      std::cout << "[EE] 3dv-client: error detected: " << error << std::endl;
	else 
		std::cout << "[II] 3dv-client: device successfully opened" << std::endl;
}

void VislabCamera::close()
{
	if (curr_devices.empty())
	{
		std::cout << "[EE] 3dv-client: no devices found" << std::endl;
		return;
		//return lib3dv::error::NONE;
	}
	else
	{
		curr_devices[0].stop_transmission();
	}
		
  //curr_devices[0].poweroff();
}

void VislabCamera::setVideoOutput(OutputInterface<cv::Mat, VislabComponent>* output)
{
	outputVideo.setOutput(output);
}

void VislabCamera::setDispariteOutput(OutputInterface<cv::Mat, VislabComponent>* output)
{
	outputDisparite.setOutput(output);
}
