/*********************************************************************
// created:    2007/04/12 - 16:30
//
// author:     Elie Al Alam & Gerald Dherbomez
// 
// version:    $Id: DbtPlyOpenCVManager.cpp 1239 2012-11-28 16:30:00Z kurdejma $
//
// purpose:    Dbite Player OpenCV Manager implementation
*********************************************************************/

#include "DbtPlyOpenCVManager.h"

#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/kernel/ComponentManager.h"
#include "Pacpus/kernel/DbiteFileTypes.h"
#include "Pacpus/kernel/Log.h"
#include "Pacpus/PacpusTools/ShMem.h"

#include <iostream>
#include <QImage>
#include <QMutex>

#include <Pacpus/structures/genericStructures.h>
#include <Pacpus/kernel/InputOutputInterface.h>

namespace pacpus {

using namespace std;
using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.base.DbtPlyOpenCVManager");

/// Construction de la fabrique de composant DbtPlyOpenCVManager
static ComponentFactory<DbtPlyOpenCVManager> sFactory("DbtPlyOpenCVManager");

/// Constructor
DbtPlyOpenCVManager::DbtPlyOpenCVManager(QString name)
    : DbtPlyFileManager (name)
{
}

/// Destructor
DbtPlyOpenCVManager::~DbtPlyOpenCVManager()
{ 

}

void DbtPlyOpenCVManager::addInputs()
{

}

void DbtPlyOpenCVManager::addOutputs()
{
    addOutput<cv::Mat, DbtPlyOpenCVManager>("image");
}


/// TODO: doc
void DbtPlyOpenCVManager::processData(road_time_t t, road_timerange_t tr, void * buf)
{
    if (!buf) {
        LOG_WARN("no data to process: empty data buffer");
        return;
    }

    // look at the dbt index in file manager and get the identifier of dbt structure
    hdfile_header_t::DataTypeT id = dbt_[dbtIndex_].pfile->getType();

    if (id == FILE_JPEG)
    {
        QString imageFile = mDbtDataPath + (char *)buf;
        LOG_TRACE("image path = " << imageFile);
        if (mVerbose)
        {
            cout << "[IMAGE]:\t"
                 << imageFile.toStdString() << endl;
        }

        cv::Mat image = cv::imread(imageFile.toStdString(),CV_LOAD_IMAGE_UNCHANGED);
        if(!image.data)
        {
            LOG_WARN("cannot load image file '" << imageFile << "'");
            return;
        }
        LOG_TRACE("image loaded");

        OutputInterface<cv::Mat, DbtPlyOpenCVManager> * imageOutput = getTypedOutput<cv::Mat, DbtPlyOpenCVManager>("image");
        if (imageOutput && imageOutput->hasConnection()) {
            imageOutput->send(image, t, tr);
        }
    }
}

ComponentBase::COMPONENT_CONFIGURATION DbtPlyOpenCVManager::configureComponent(XmlComponentConfig config)
{    
    return DbtPlyFileManager::configureComponent(config);
}

void DbtPlyOpenCVManager::startActivity()
{
    DbtPlyFileManager::startActivity();
}

void DbtPlyOpenCVManager::stopActivity()
{

}

} // namespace pacpus
