#ifndef DISKWRITER_H
#define DISKWRITER_H

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/DbiteFileTypes.h>
#include <Pacpus/kernel/DbiteException.h>

// Includes, qt.
#include <QTimer>

// Includes, lib3dv.
#include <lib3dv/device.h>
//#include "20150310_lib3dv-1.2.0/src/DiskWriter.h"
#include "DiskWriter.h"
#include "VislabImageProcessor.h"

#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/address.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

#if (OPENCV_MAJOR == 3)
#include <opencv2/opencv.hpp>
#include <opencv2/highgui.hpp>
#else
#include <opencv/cv.h>
#include <opencv/highgui.h>
#endif


using pacpus::DbiteFile;
using pacpus::DbiteException;
using pacpus::WriteMode;

class DiskWriter : public VislabImageProcessor
{
public:

    /// Ctor of CVWebcamComponent.
    DiskWriter(const QString name, lib3dv::image::type::types imageType);

    void process(cv::Mat const& frame);

private:
    DbiteFile mDBTFile;
    QString mFilenameTemplate;
    unsigned int mImageCounter;
    QString mDbtfilename;
    lib3dv::image::type::types mImageType;

};

#endif // DiskWriter_H
