#include "VislabImageProcessor.h"

#if (OPENCV_MAJOR == 3)
#   include <opencv2/opencv.hpp>
#   include <opencv2/highgui.hpp>
#else
#   include <opencv/cv.h>
#   include <opencv/highgui.h>
#endif


    VislabImageProcessor::VislabImageProcessor(const QString& name, lib3dv::image::type::types imageType)
        :mImageType(imageType), mName(name)
    {
    }

    void VislabImageProcessor::image_callback(boost::shared_ptr< const lib3dv::image> image)
    {
        if(image->type() == mImageType)
        {
            /*! Type picture : Mono 8 */
            if(image->format() == lib3dv::image::format::MONO8)
            {
                cv::Mat cvimage(image->height(), image->width(), CV_8UC1);
                std::memcpy(cvimage.data,image->data(),image->height()*image->width());
                /*for(int i=0;i<image->m_height*image->m_width;i++)
                {
                    cvimage.data[i] = image->m_buffer[i];
                }*/
                process(cvimage);
            }

            /*! Type picture : Mono 16 */
            if(image->format() == lib3dv::image::format::MONO16)
            {
                cv::Mat cvimage(image->height(), image->width(), CV_16UC1);
                std::memcpy(cvimage.data,image->data(),image->height()*image->width()*2);
                /**for(int i=0;i<image->m_height*image->m_width*2;i++)
                {
                    cvimage.data[i] = image->m_buffer[i];
                }*/
                process(cvimage);
            }
        }
    }

    QString VislabImageProcessor::getName()
    {
        return mName;
    }




