#ifndef OUTPUTTER_H
#define OUTPUTTER_H

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <string.h>
//#include "VislabComponent.hpp"
#include <Pacpus/kernel/InputOutputInterface.h>
#include "VislabImageProcessor.h"

// Includes, lib3dv.
#include <lib3dv/device.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/address.hpp>
#include <boost/bind.hpp>
#include <boost/ref.hpp>
#include <boost/thread.hpp>

namespace pacpus {
class VislabComponent;
}

class Outputter : public VislabImageProcessor
{
public:

	/// Ctor of CVWebcamComponent.
	Outputter(lib3dv::image::type::types imageType);
    void setOutput(pacpus::OutputInterface<cv::Mat, pacpus::VislabComponent>* output);
	
	void process(cv::Mat const& frame);

private:

	pacpus::OutputInterface<cv::Mat, pacpus::VislabComponent>* output_;
	

};

#endif // OUTTPUTER_H
